	function [Zodd, Podd, Zeven, Peven] = SORT_LATTICE_POLES_HB(P)
	
	% 	Sorts the poles and zeros of a digital half-band lowpass filter  
	%	into poles and zeros for upper and lower branches in a lattice filter 
	%	according to section  12.2.1.  
	%
	% 	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% 	Author: 		Lars Wanhammar, Beginning of WWI + 100
	% 	Modified by: 	LW 2014-12-30
	% 	Version: 		1
	% 	Known bugs:		
	% 	Report bugs to:	Wanhammar@gmail.com

	N = length(P);	
	if mod(N-1,2) == 0	%	Lowpass or highpass case
		if mod(N-1,4) ~= 0, Sodd = 0; else Sodd = 1; end
		% Check for the half-band case
		if abs(real(P(1))) <= 100*eps	
			P(1) = [];
			A = [angle(P), P];
			if Sodd == 0
				% For N = 3, 7, 11,...
				Peven = cplxpair([A(1:4:end,2); A(2:4:end,2)]);
				Podd0 = [A(3:4:end,2); A(4:4:end,2)];
				Podd = cplxpair([0;Podd0]);
			else
				% For N = 5, 9, 13,...
				Peven = cplxpair([A(1:4:end-1,2); A(2:4:end-1,2)]);
				Podd0 = [A(3:4:end,2); A(4:4:end,2)];
				Podd = cplxpair([0; Podd0]);
			end	
		end
		Podd0 = Podd;
		Podd0(abs(Podd0) < 10*eps) = [];
		Zodd = 1./Podd0;
		Zeven = 1./Peven;	
	else
		disp([Error - not a half-band filter'])
	end

